<?php
/**
 * Astra functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Define Constants
 */
define( 'ASTRA_THEME_VERSION', '4.3.1' );
define( 'ASTRA_THEME_SETTINGS', 'astra-settings' );
define( 'ASTRA_THEME_DIR', trailingslashit( get_template_directory() ) );
define( 'ASTRA_THEME_URI', trailingslashit( esc_url( get_template_directory_uri() ) ) );
define( 'ASTRA_PRO_UPGRADE_URL', 'https://wpastra.com/pro/?utm_source=dashboard&utm_medium=free-theme&utm_campaign=upgrade-now' );
define( 'ASTRA_PRO_CUSTOMIZER_UPGRADE_URL', 'https://wpastra.com/pro/?utm_source=customizer&utm_medium=free-theme&utm_campaign=upgrade' );

/**
 * Minimum Version requirement of the Astra Pro addon.
 * This constant will be used to display the notice asking user to update the Astra addon to the version defined below.
 */
define( 'ASTRA_EXT_MIN_VER', '4.1.0' );

/**
 * Setup helper functions of Astra.
 */
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-theme-options.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-theme-strings.php';
require_once ASTRA_THEME_DIR . 'inc/core/common-functions.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-icons.php';

/**
 * Update theme
 */
require_once ASTRA_THEME_DIR . 'inc/theme-update/astra-update-functions.php';
require_once ASTRA_THEME_DIR . 'inc/theme-update/class-astra-theme-background-updater.php';

/**
 * Fonts Files
 */
require_once ASTRA_THEME_DIR . 'inc/customizer/class-astra-font-families.php';
if ( is_admin() ) {
	require_once ASTRA_THEME_DIR . 'inc/customizer/class-astra-fonts-data.php';
}

require_once ASTRA_THEME_DIR . 'inc/lib/webfont/class-astra-webfont-loader.php';
require_once ASTRA_THEME_DIR . 'inc/customizer/class-astra-fonts.php';

require_once ASTRA_THEME_DIR . 'inc/dynamic-css/custom-menu-old-header.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/container-layouts.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/astra-icons.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-walker-page.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-enqueue-scripts.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-gutenberg-editor-css.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-wp-editor-css.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/block-editor-compatibility.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/inline-on-mobile.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/content-background.php';
require_once ASTRA_THEME_DIR . 'inc/class-astra-dynamic-css.php';
require_once ASTRA_THEME_DIR . 'inc/class-astra-global-palette.php';

/**
 * Custom template tags for this theme.
 */
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-attr.php';
require_once ASTRA_THEME_DIR . 'inc/template-tags.php';

require_once ASTRA_THEME_DIR . 'inc/widgets.php';
require_once ASTRA_THEME_DIR . 'inc/core/theme-hooks.php';
require_once ASTRA_THEME_DIR . 'inc/admin-functions.php';
require_once ASTRA_THEME_DIR . 'inc/core/sidebar-manager.php';

/**
 * Markup Functions
 */
require_once ASTRA_THEME_DIR . 'inc/markup-extras.php';
require_once ASTRA_THEME_DIR . 'inc/extras.php';
require_once ASTRA_THEME_DIR . 'inc/blog/blog-config.php';
require_once ASTRA_THEME_DIR . 'inc/blog/blog.php';
require_once ASTRA_THEME_DIR . 'inc/blog/single-blog.php';

/**
 * Markup Files
 */
require_once ASTRA_THEME_DIR . 'inc/template-parts.php';
require_once ASTRA_THEME_DIR . 'inc/class-astra-loop.php';
require_once ASTRA_THEME_DIR . 'inc/class-astra-mobile-header.php';
   ////////
/**
 * Functions and definitions.
 */
require_once ASTRA_THEME_DIR . 'inc/class-astra-after-setup-theme.php';
/////////////////////////
// Required files.
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-admin-helper.php';

require_once ASTRA_THEME_DIR . 'inc/schema/class-astra-schema.php';

/* Setup API */
require_once ASTRA_THEME_DIR . 'admin/includes/class-astra-api-init.php';

if ( is_admin() ) {
	/**
	 * Admin Menu Settings
	 */
	require_once ASTRA_THEME_DIR . 'inc/core/class-astra-admin-settings.php';
	require_once ASTRA_THEME_DIR . 'admin/class-astra-admin-loader.php';
	require_once ASTRA_THEME_DIR . 'inc/lib/astra-notices/class-astra-notices.php';
}

/**
 * Metabox additions.
 */
require_once ASTRA_THEME_DIR . 'inc/metabox/class-astra-meta-boxes.php';

require_once ASTRA_THEME_DIR . 'inc/metabox/class-astra-meta-box-operations.php';

/**
 * Customizer additions.
 */
require_once ASTRA_THEME_DIR . 'inc/customizer/class-astra-customizer.php';

/**
 * Astra Modules.
 */
require_once ASTRA_THEME_DIR . 'inc/modules/posts-structures/class-astra-post-structures.php';
require_once ASTRA_THEME_DIR . 'inc/modules/related-posts/class-astra-related-posts.php';

/**
 * Compatibility
 */
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-gutenberg.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-jetpack.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/woocommerce/class-astra-woocommerce.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/edd/class-astra-edd.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/lifterlms/class-astra-lifterlms.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/learndash/class-astra-learndash.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-beaver-builder.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-bb-ultimate-addon.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-contact-form-7.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-visual-composer.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-site-origin.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-gravity-forms.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-bne-flyout.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-ubermeu.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-divi-builder.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-amp.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-yoast-seo.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-starter-content.php';
require_once ASTRA_THEME_DIR . 'inc/addons/transparent-header/class-astra-ext-transparent-header.php';
require_once ASTRA_THEME_DIR . 'inc/addons/breadcrumbs/class-astra-breadcrumbs.php';
require_once ASTRA_THEME_DIR . 'inc/addons/scroll-to-top/class-astra-scroll-to-top.php';
require_once ASTRA_THEME_DIR . 'inc/addons/heading-colors/class-astra-heading-colors.php';
require_once ASTRA_THEME_DIR . 'inc/builder/class-astra-builder-loader.php';

// Elementor Compatibility requires PHP 5.4 for namespaces.
if ( version_compare( PHP_VERSION, '5.4', '>=' ) ) {
	require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-elementor.php';
	require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-elementor-pro.php';
	require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-web-stories.php';
}

// Beaver Themer compatibility requires PHP 5.3 for anonymus functions.
if ( version_compare( PHP_VERSION, '5.3', '>=' ) ) {
	require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-beaver-themer.php';
}

require_once ASTRA_THEME_DIR . 'inc/core/markup/class-astra-markup.php';

/**
 * Load deprecated functions
 */
require_once ASTRA_THEME_DIR . 'inc/core/deprecated/deprecated-filters.php';
require_once ASTRA_THEME_DIR . 'inc/core/deprecated/deprecated-hooks.php';
require_once ASTRA_THEME_DIR . 'inc/core/deprecated/deprecated-functions.php';



/****** 'Remove Billing Fields in WooCommerce Checkout Page Manually'*****/
add_filter( 'woocommerce_checkout_fields' , 'remove_billing_fields_from_checkout', 1);
function remove_billing_fields_from_checkout( $fields ) {
    $fields[ 'billing' ] = array();
    return $fields;
}


/****** 
 * 'Remove shipping Fields in WooCommerce Checkout Page Manually' ---->
 * 1- woocommerce dashboard 2- Shipping location(s) 'disable shipping &shipping calculation'
 * *******/

/************ END remove billing in checkout page***************/


/**Redirect to Checkout Page**/ 
/*
add_filter( 'woocommerce_add_to_cart_redirect', 'misha_skip_cart_redirect_checkout' );
 
function misha_skip_cart_redirect_checkout( $url ) {
	return wc_get_checkout_url();
}*/
/*END-Redirect to Checkout Page*/


/** Add Mobile Phone Number field to WooCommerce checkout and save in order details**/

function add_custom_phone_field($fields) {

    $fields['billing']['billing_phone'] = array(
        
        'required' => true,
        'class' => array('form-row-wide'),
        'clear' => true,
		'id' => 'jana',
		'placeholder' => '77 0000 0000',
		 'custom_attributes' => array(
            'oninput' => 'validateNumericInput(this , 13)',
			'style' => 'direction: ltr;padding-left: 40px;padding-right: 0px;', // Add this line for left alignment

        ),
    );
    return $fields;
}

add_filter('woocommerce_checkout_fields', 'add_custom_phone_field', 99);

function save_custom_phone_field($order_id) {
    if (!empty($_POST['billing_phone'])) {
        update_post_meta($order_id, '_billing_phone', sanitize_text_field($_POST['billing_phone']));
    }
}
add_action('woocommerce_checkout_update_order_meta', 'save_custom_phone_field');

/**END-Add the custom field to the checkout page**/


/*Remove the Additional Information Tab*/
add_filter( 'woocommerce_product_tabs', 'woo_remove_product_tabs', 98 );

function woo_remove_product_tabs( $tabs ) {
    unset( $tabs['additional_information'] );  	// Remove the additional information tab

    return $tabs;
}

/*END*/

//Conceal the Quantity Field in All Products
function cw_remove_quantity_fields( $return, $product ) {
    return true;
}
add_filter( 'woocommerce_is_sold_individually', 'cw_remove_quantity_fields', 10, 2 );

/*END*/

/*How Do I Turn Off Image Zoom in WooCommerce*/
function remove_image_zoom_support() {
remove_theme_support( 'wc-product-gallery-zoom' );
}
add_action( 'wp', 'remove_image_zoom_support', 100 );
/*END*/

/* Change add to cart text on single product page*/
add_filter( 'woocommerce_product_single_add_to_cart_text', 'woocommerce_add_to_cart_button_text_single' ); 
function woocommerce_add_to_cart_button_text_single() {
    return __( 'اضافة الى السلة ', 'woocommerce' ); 
}
/*END*/

/*remove related product*/
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
/*END*/

/*allow the cart page one product*/
add_filter( 'woocommerce_add_to_cart_validation', 'bbloomer_only_one_in_cart', 9999 );
   
function bbloomer_only_one_in_cart( $passed ) {
   wc_empty_cart();
   return $passed;
}
/*END*/

/* Remove product data tabs */
add_filter( 'woocommerce_enable_order_notes_field', '__return_false' );

/*END*/

add_action('wp_ajax_validate_PinCode', 'validate_PinCode');

// register the ajax action for unauthenticated users
add_action('wp_ajax_nopriv_validate_PinCode', 'validate_PinCode');

// handle the ajax request
function validate_PinCode() {
	$msisdn = $_REQUEST['msisdn'];
	$appId = $_REQUEST['appId'];
    $thirdPartyId = $_REQUEST ['thirdPartyId'];
	$countryId= $_REQUEST['countryId'];
	$currency= $_REQUEST['currency'];
	$tax= number_format((float)$_REQUEST['tax'], 2, '.', '');
	$price= $_REQUEST['price'];
	$cPPPId= $_REQUEST['cPPPId'];
	$packageName= $_REQUEST['packageName'];
	$paymentMethodId= $_REQUEST['paymentMethodId'];
	$token = $_REQUEST['token'];
	$pinCode = $_REQUEST['pinCode'];
	$email = $_REQUEST['email'];
	$optionalField_1 = $_REQUEST['optionalField_1'];
	$optionalField_2 = $_REQUEST['optionalField_2'];
	
	switch ($currency) {
	  case "IQD":
		$countryId = 2;
		break; 
	}
	
	switch ($paymentMethodId) {
	  case 3:
		$paymentMethodId = 9;
		break;		
	}
	
	$signature = getSignature($countryId,$price,$cPPPId,$tax,$msisdn,$paymentMethodId,$currency,$email);
	
	$ajaxRes = 0;
	$refId = 0;
	$message="N/A";
	
	 
	
	  if ($thirdPartyId == 'asiamall'){
	    $thirdPartyId = 2 ;
	   }else{
		   $thirdPartyId = 1;
	  }
	
	$result = postJson("https://tkonlinepay.com/MobileOperatorWalletsIQV3/paymentOperationsWPIQ/validatePinCode", array(
		'appId' => $appId,
		'counttryId' => $countryId,
		'paymentMethodId' => $paymentMethodId,
		'countryProductPaymentPackageId' => $cPPPId,
		'price' => $price ,
		'tax' => $tax,
		'packageName' => $packageName,
		'currency' => $currency,
		'signature' => $signature,
		'msisdn' => $msisdn,
	    'token' => $token,
		'pinCode' => $pinCode,
	    'email' => $email,
	    'optionalField_1' => $optionalField_1,
	    'optionalField_2' =>  $optionalField_2,
	    'thirdPartyId'  =>  $thirdPartyId));
	$APIResponse = (array) $result;
		
		    $errorCode = $APIResponse["errorCode"];
			$message = $APIResponse["errorDisc"];
			$token = $APIResponse["token"];
			$refId = $APIResponse["refId"];
	        $voucherCode =  $APIResponse["voucherCode"];
	
	if ($errorCode == 0 ){
		$ajaxRes = 0;
	}else{
		$ajaxRes = -1;		
	}
	
    

 wp_send_json_success([$ajaxRes , $refId , $message,$voucherCode]);
	
    // or, on error, return error json data
    wp_send_json_error([/* some data here */]);
}


//////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////

add_action('wp_ajax_send_pin_code', 'send_pin_code');

// register the ajax action for unauthenticated users
add_action('wp_ajax_nopriv_send_pin_code', 'send_pin_code');

// handle the ajax request
function send_pin_code() {
	$msisdn = $_REQUEST['msisdn'];
	$appId = $_REQUEST['appId'];
    $thirdPartyId = $_REQUEST ['thirdPartyId'];
	$countryId= $_REQUEST['countryId'];
	$currency= $_REQUEST['currency'];
	$tax= number_format((float)$_REQUEST['tax'], 2, '.', '');
	$price= $_REQUEST['price'];
	$cPPPId= $_REQUEST['cPPPId'];
	$packageName= $_REQUEST['packageName'];
	$paymentMethodId= $_REQUEST['paymentMethodId'];
	$email = $_REQUEST ['email'];
	
	
	switch ($currency) {
	  case "IQD":
		$countryId = 2;
		break;
	}
	
	switch ($paymentMethodId) {
	  case 3:
		$paymentMethodId = 9;
		break;
	}
	
	
	
	  if ($thirdPartyId == 'asiamall'){
	    $thirdPartyId = 2 ;
	   }else{
		  $thirdPartyId = 1;
	  }

	   $thirdPartyId = 2 ;
	
	
	
 if ($cPPPId == 346 || $cPPPId == 100337 || $cPPPId == 177396  ) {
       if ($cPPPId == 346){
	    $promo_code = '5discount';
	   }
	 
	 if ( $cPPPId == 100337 || $cPPPId == 177396  ){
		   $promo_code = '15discount';
	 }
	 
        if (function_exists('WC')) {
            if (WC()->session === null) {
                WC()->initialize_session();
            }

            if (WC()->cart === null) {
                wc_load_cart();
            }

            if (!WC()->cart->has_discount($promo_code) && wc_get_coupon_id_by_code($promo_code)) {
                WC()->cart->add_discount($promo_code);
				  // Set transient to prevent redirect loop, expire after 1 minute
            wp_send_json_success([-10 , null , null,null]);
        exit;
              //  wp_send_json_success(['message' => "Promo code '{$promo_code}' applied."]);
            } else {
              //  wp_send_json_error(['message' => 'Coupon is already applied or invalid.']);
            }
        }
    }

	
	
	
	$signature = getSignature($countryId,$price,$cPPPId,$tax,$msisdn,$paymentMethodId,$currency,$email);
	
	$ajaxRes = 0;
	$refId = 0;
	$message="N/A";
	
	$result = postJson("https://tkonlinepay.com/MobileOperatorWalletsIQV3/paymentOperationsWPIQ/generateToken", array(
		'appId' => $appId,
		'counttryId' => $countryId,
		'paymentMethodId' => $paymentMethodId,
		'countryProductPaymentPackageId' => $cPPPId,
		'price' => $price ,
		'tax' => $tax,
		'currency' => $currency,
		'packageName' => $packageName,
		'signature' => $signature,
		'msisdn' => $msisdn,
	    'email' => $email,
	    'thirdPartyId'  =>  $thirdPartyId));
	
	
	$APIResponse = (array) $result;
		
		    $errorCode = $APIResponse["errorCode"];
			$message = $APIResponse["errorDisc"];
			$token = $APIResponse["token"];
			$refId = $APIResponse["refId"];
	
	if ($errorCode == 0 ){
		
		$result = postJson("https://tkonlinepay.com/MobileOperatorWalletsIQV3/paymentOperationsWPIQ/sendPinCode", array(
			'appId' => $appId,
			'counttryId' => $countryId,				
			'paymentMethodId' =>  $paymentMethodId,
			'countryProductPaymentPackageId' =>  $cPPPId,				
			'price' => $price ,
			'tax' => $tax,
			'currency' => $currency,
			'packageName' => $packageName,
			'signature' => $signature,
			'msisdn' => $msisdn,				
			'token' => $token,
		    'email' => $email,
		   'thirdPartyId'  =>  $thirdPartyId));
				
				
		$res = (array) $result;
		$resultCode = $res["errorCode"];
		$message = $res["errorDisc"];
		$refId = $res["refId"];
				
				
		if ($resultCode == 0 ){
			$ajaxRes = 0;
		}else{
			$ajaxRes = -2;
			
		}
		
		
	
	}else{
		$ajaxRes = -1;
	}
	
  
 wp_send_json_success([$ajaxRes , $refId , $message,$token]);
	
    // or, on error, return error json data
    wp_send_json_error([/* some data here */]);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////

function getSignature(
    $counttryId,
    $price,
    $cPPPId,
    $tax,
    $msisdn,
    $paymentMethodId,
    $currency,
	$email
) {
    //print_r($paymentOps);

    $KEY = "@n@S_tK@395$$~98";
    $AGENT_USER_NAME = "AnaS$\$TK_1595~98";
    $AGENT_USER_PASSWORD = "P@$\$w0rd_#&!@9641~98";

    $clearSingture =
        $KEY .
        $counttryId .
        $price .
        $cPPPId .
        $tax .
        $msisdn .
        $paymentMethodId .
        $AGENT_USER_NAME .
        $currency .
        $AGENT_USER_PASSWORD .
        $KEY .
		$email;

    $signature = hash("sha256", $clearSingture, true);
    $signature = implode(unpack("H*", $signature));
    return $signature;
}
////////////////////////////////////////////////////////////////////////////////////////////////////

function postJson($resource, array $parameters = [], array $data = [])
{
    // the query string
   // $query = http_build_query(["access_token" => $this->token]);

    // construct curl resource
    $curl = curl_init("$resource");

    // data will be json encoded
    $parameters = json_encode($parameters);
   // print_r($parameters);

    $headers = [
        "Accept: application/json",
        "Authorization: Basic UC1YblNnNlNoNDlvNzpUUTM4MjM=",
        "Content-Type:application/json",
    ];

    // additional options
    curl_setopt_array($curl, [
        CURLOPT_POST => true,
        CURLOPT_HEADER => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => $parameters,
    ]);

    // do the call

    $answer = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $json_data = mb_substr($answer, curl_getinfo($curl, CURLINFO_HEADER_SIZE));

    $data = json_decode($json_data);

    //$info = curl_getinfo($curl);
    //print_r($info);

    // clean up curl resource
    curl_close($curl);

    // bad request
    if (!$httpCode || $httpCode == 400) {
        return false;
    }

    return $data;
}

// Change order status from Processing to Completed
function change_order_status_to_completed($order_id) {
    $order = wc_get_order($order_id);

    if ($order) {
        // Check if the order is currently in "Processing" status
        if ($order->has_status('processing') || $order->has_status('pending') ) {
            $order->update_status('completed');
        }
    }
}

// Hook into the order status change process
add_action('woocommerce_order_status_processing', 'change_order_status_to_completed');
////END


//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
/*
add_action('wp_ajax_get_asia_orders_log', 'get_asia_orders_log');

// register the ajax action for unauthenticated users
add_action('wp_ajax_nopriv_get_asia_orders_log', 'get_asia_orders_log');

function get_asia_orders_log() {
	$msisdn = $_REQUEST['msisdn'];
	$appId = $_REQUEST['appId']; 
	$countryId= $_REQUEST['countryId'];
	$token= $_REQUEST['token'];
	$pinCode= $_REQUEST['pinCode'];
	
	
	
	
	// $signature = getlogSignature($countryId,$msisdn,$appId);
	
	$ajaxRes = 0;
	$refId = 0;
	$message="N/A";
	
	$result = postJson("https://tkonlinepay.com/MobileOperatorWalletsIQV3/getOrdersLog/getAsiaOrdersLog", array(
		'appId' => $appId,
		'countryId' => $countryId,		
		'msisdn' => $msisdn,
		'pinCode' => $pinCode) );
	
	
	$APIResponse = (array) $result;
		
		 
	
	
  
 wp_send_json_success([$APIResponse, 'JunJun']);
	
    // or, on error, return error json data
    wp_send_json_error([ some data here ]);
}
*/

////////////////////////////////////////////////////////////////////////////////////////
//
add_action('wp_ajax_send_free_pin_code', 'send_free_pin_code');

// register the ajax action for unauthenticated users
add_action('wp_ajax_nopriv_send_free_pin_code', 'send_free_pin_code');
function send_free_pin_code() {
	$msisdn = $_REQUEST['msisdn'];
	$appId = $_REQUEST['appId'];
	$countryId= $_REQUEST['countryId'];
	
	
	$result = postJson("https://tkonlinepay.com/MobileOperatorWalletsIQV3/getOrdersLog/sendFreePinCode", array(
		'msisdn' => $msisdn,
		'appId' => $appId,
		'countryId' => $countryId));
	
	$APIResponse = (array) $result;
	 $errorCode = $APIResponse["errorCode"];
	 $errorMessage = $APIResponse["errorMessage"];
	
	
		    $errorCode = $APIResponse["errorCode"];
			if ($errorCode == 0 ){
				$ajaxRes = 0;
			}else{
				$ajaxRes = -2;
			}
	
	 wp_send_json_success([$ajaxRes , $errorMessage]);
	
    // or, on error, return error json data
    wp_send_json_error([/* some data here */]);
	
	
}




//
////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action('wp_ajax_check_OTP_for_asia_orders_log', 'check_OTP_for_asia_orders_log');

// register the ajax action for unauthenticated users
add_action('wp_ajax_nopriv_check_OTP_for_asia_orders_log', 'check_OTP_for_asia_orders_log');

function check_OTP_for_asia_orders_log() {
	$msisdn = $_REQUEST['msisdn'];
	$appId = $_REQUEST['appId'];
	$countryId= $_REQUEST['countryId'];
	$pinCode= $_REQUEST['pinCode'];

$result = postJson("https://tkonlinepay.com/MobileOperatorWalletsIQV3/getOrdersLog/checkOTPForAsiaOrdersLog", array(
		'msisdn' => $msisdn,
		'appId' => $appId,
		'countryId' => $countryId,
		'pinCode' => $pinCode));


	 $APIResponse = (array) $result;
	 $errorCode = $APIResponse["errorCode"];	
	 $response = $APIResponse["ordersLogOutputs"];
	 $errorMessage = $APIResponse["errorMessage"];
		 
	
	
  
 wp_send_json_success([$errorCode , $response, $errorMessage,  'JunJun']);
	
    // or, on error, return error json data
    wp_send_json_error([/* some data here */]);
}
///////////////////////////////////////////
/*for remove s/k*/
add_filter( 'wc_product_sku_enabled', '__return_false' );
/*END*/


function save_coupon_before_redirect() {
    if (isset($_GET['getFrom'])) {
        $coupon_code = sanitize_text_field($_GET['getFrom']);
        WC()->session->set('saved_coupon', $coupon_code);
    }
	
	 if (isset($_GET['msisdn'])) {
        $asiaMS = sanitize_text_field($_GET['msisdn']);
        WC()->session->set('asiaMS', $asiaMS);
    }
	
}
add_action('wp_loaded', 'save_coupon_before_redirect');


function apply_saved_coupon_and_redirect() {
    if (WC()->session->get('saved_coupon')) {
        $coupon_code = WC()->session->get('saved_coupon');

        if (!WC()->cart->has_discount($coupon_code)) {
            WC()->cart->apply_coupon($coupon_code);
            wc_add_notice(__('Coupon applied successfully!', 'woocommerce'), 'success');
        }

        WC()->session->__unset('saved_coupon'); // Remove after applying

        // Redirect to checkout after applying coupon
        wp_safe_redirect(wc_get_checkout_url());
        exit;
    }
}
add_action('template_redirect', 'apply_saved_coupon_and_redirect');


add_filter( 'woocommerce_add_to_cart_redirect', 'misha_skip_cart_redirect_checkout' );
 
function misha_skip_cart_redirect_checkout( $url ) {
	    if ( WC()->session && WC()->session->get('asiaMS') ) {
        $asiaMS = WC()->session->get('asiaMS');

        $url = add_query_arg(
            array(
                'msisdn' => $asiaMS,
            ),
            wc_get_checkout_url()
        );
    } else {
        $url = wc_get_checkout_url();
    }

    return $url;
}

